import { _decorator, Component, Node } from 'cc';
import { PopupManager } from './PopupManager';
const { ccclass, property } = _decorator;

@ccclass('MenuController')
export class MenuController extends Component {

    @property(PopupManager)
    private popupManager: PopupManager = null!;

    @property(Node)
    private buttonNode1: Node = null!;

    @property(Node)
    private buttonNode2: Node = null!;

    @property(Node)
    private popupNode1: Node = null!;

    @property(Node)
    private popupNode2: Node = null!;

    protected onEnable(): void {
        this.buttonNode1.on(Node.EventType.TOUCH_END, this._logic1, this);
        this.buttonNode2.on(Node.EventType.TOUCH_END, this._logic2, this);
    }
    
    protected onDisable(): void {
        this.buttonNode1.off(Node.EventType.TOUCH_END, this._logic1, this);
        this.buttonNode2.off(Node.EventType.TOUCH_END, this._logic2, this);    
    }

    private _logic1() {
        this.popupManager.showPopup(this.popupNode1.uuid);
    }

    private _logic2() {
        this.popupManager.showPopup(this.popupNode2.uuid);
    }
}


