import { _decorator, Component, Input, input, KeyCode, Node, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('PlayerController')
export class PlayerController extends Component {
    @property
    private moveSpeed: number = 50;

    private _direction: Vec3 = new Vec3();

    protected start(): void {
        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    protected onDestroy(): void {
        input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    protected update(deltaTime: number): void {
        if (!this._direction.equals(Vec3.ZERO)) {
            const moveStep = this._direction.clone();
            moveStep.multiplyScalar(this.moveSpeed * deltaTime);
            
            const newPosition = this.node.position.clone();
            newPosition.add(moveStep);
            this.node.setPosition(newPosition);
        }
    }

    private onKeyDown(event: any): void {
        switch (event.keyCode) {
            case KeyCode.KEY_W:
                this._direction.y = 1;
                break;
            case KeyCode.KEY_S:
                this._direction.y = -1;
                break;
            case KeyCode.KEY_A:
                this._direction.x = -1;
                break;
            case KeyCode.KEY_D:
                this._direction.x = 1;
                break;
        }
    }

    private onKeyUp(event: any): void {
        switch (event.keyCode) {
            case KeyCode.KEY_W:
                if (this._direction.y === 1) this._direction.y = 0;
                break;
            case KeyCode.KEY_S:
                if (this._direction.y === -1) this._direction.y = 0;
                break;
            case KeyCode.KEY_A:
                if (this._direction.x === -1) this._direction.x = 0;
                break;
            case KeyCode.KEY_D:
                if (this._direction.x === 1) this._direction.x = 0;
                break;
        }
    }

    
}