import { _decorator, Component, Node, Vec3 } from 'cc';
const { ccclass, property,  } = _decorator;

@ccclass('FollowObject')
export class FollowObject extends Component {
    @property({ type: Node })
    private target: Node | null = null;

    @property
    private followSpeed: number = 5;

    @property
    private offset: Vec3 = new Vec3(0, 0, 0);

    protected start(): void {
        if (!this.target) {
            console.warn('Цель для FollowObject не задана');
        }
    }

    protected lateUpdate(deltaTime: number): void {
        if (!this.target) return;

        const targetPosition = this.target.position.clone();

        targetPosition.add(this.offset);

        const currentPosition: Vec3 = this.node.position.clone();
        const newPosition: Vec3 = new Vec3();

        Vec3.lerp(
            newPosition,
            currentPosition,
            targetPosition,
            this.followSpeed * deltaTime
        );

        this.node.setPosition(newPosition);
    }
}