export class ServiceLocator {
    private static _services = new Map<Function, any>();

    public static register<T>(type: new () => T, instance: T): void {
        this._services.set(type, instance);
    }

    public static get<T>(type: new () => T): T {
        const service = this._services.get(type);
        if (!service) {
            throw new Error(`Service "${type.name}" not registered`);
        }
        return service as T;
    }

    public static unregister(type: Function): void {
        this._services.delete(type);
    }
}

export function getService<T>(type: new () => T): T {
    return ServiceLocator.get<T>(type);
}